# Rmap Baseline
# Copyright 2008 by Brian C. Christensen

# 080613 - start first draft
# 081101 - added index and check tables

import ORM
##import math

debug = 1

def BaseRmap(project):
    tables = project.GetList('RelationalTable')
    for table in tables:
        if table.InUse:
            table.BaseName = table.Name
            table.InBase = 'y'
        else:
            table.BaseName = None
            table.InBase = None            

        columns = table.GetList('RelationalColumn')
        for column in columns:
            if column.InUse:
                column.BaseSeq = column.Seq
                column.BaseName = column.Name
                column.BaseNotNull = column.NotNull
                column.BaseDataType = column.DataType
                column.BaseKey = column.Key
                column.BaseRelationalReferenceID = column.RelationalReferenceID
                column.InBase = 'y'
            else:
                column.BaseSeq = None
                column.BaseName = None
                column.BaseNotNull = None
                column.BaseDataType = None
                column.BaseKey = None
                column.BaseRelationalReferenceID = None
                column.InBase = None

        indices = table.GetList('RelationalIndex') # verify this part
        for index in indices:
            indexcols = index.GetList('RelationalIndexColumn')
            if index.InUse:
                index.BaseSeq = index.Seq
                index.BaseName = index.Name
                index.BaseKey = index.Key
                index.BaseUnique = index.Unique
                index.BaseRelationalTableID = index.RelationalTableID
                index.InBase = 'y'
                for col in indexcols:
                    if col.InUse:
                        col.InBase = 'y'
                    else:
                        col.InBase = None
            else:
                index.BaseSeq = None
                index.BaseName = None
                index.BaseKey = None
                index.BaseUnique = None
                index.BaseRelationalTableID = None
                index.InBase = None
                for col in indexcols:
                    col.InBase = None

##        checks = table.GetList('RelationalCase')
##        for check in checks:
##            if check.InUse:
##                check.BaseSeq = check.Seq
##                check.BaseName = check.Name
##                check.BaseCheck = check.Check
##                check.BaseRelationalTableID = check.RelationalTableID
##                check.InBase = 'y'
##            else:
##                check.BaseSeq = None
##                check.BaseName = None
##                check.BaseCheck = None
##                check.BaseRelationalTableID = None
##                check.InBase = None

def Do(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        hint('Not for use in main report')
        return  # do nothing

    db = Data.DBObject  # will get objects from this database
    report = db.GetObject('Report',rid)

    Data.AddAlias('BaseRelationalReference', 'RelationalColumn')  # not in old install script
    Data.AddAlias('BaseRelationalTable', 'RelationalTable')

    BaseRmap( report.Project )

    Data.SetUndo('Baseline Rmap')

Do(self)

